/*
 * Decompiled with CFR 0.152.
 */
package engine;

import engine.ImageLib;
import engine.Path;
import engine.SpritePath;
import engine.WaypointPath;
import gameobjects.HPBall;
import gameobjects.HPGenerator;
import gameobjects.Key;
import gameobjects.Mushroom;
import gameobjects.Platform;
import gameobjects.Player;
import gameobjects.Sandstone;
import gameobjects.Shredder;
import gameobjects.Speedfield;
import gameobjects.Spikes;
import gameobjects.Sprite;
import gameobjects.Wall;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import view.GamePanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Level {
    private ArrayList<Sprite> sprites;
    private Hashtable<String, Path> paths;
    private Hashtable<String, Sprite> actorIndex;
    private Player player;
    private GamePanel parent;
    private ImageLib img;

    public Level(GamePanel p, ImageLib img) {
        this.parent = p;
        this.img = img;
    }

    public boolean load(String filename) {
        this.sprites = new ArrayList();
        this.paths = new Hashtable();
        this.actorIndex = new Hashtable();
        BufferedImage[] vert = this.img.tileImages(this.img.getImagesByName("wall"), 16, 568);
        BufferedImage[] hor = this.img.tileImages(this.img.getImagesByName("wall"), 800, 16);
        Wall boundary = new Wall(vert, 0.0, 16.0, 10000L, this.parent);
        this.sprites.add(boundary);
        boundary = new Wall(vert, 786.0, 16.0, 10000L, this.parent);
        this.sprites.add(boundary);
        boundary = new Wall(hor, 0.0, 0.0, 10000L, this.parent);
        this.sprites.add(boundary);
        boundary = new Wall(hor, 0.0, 584.0, 10000L, this.parent);
        this.sprites.add(boundary);
        try {
            Document D = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new File("level/" + filename));
            NodeList level = D.getElementsByTagName("level");
            Element root = (Element)level.item(0);
            this.addElements(root);
        }
        catch (Exception e) {
            System.out.println(e.getLocalizedMessage());
            return false;
        }
        return true;
    }

    private double transformX(double x) {
        return x + 16.0;
    }

    private double transformY(double y) {
        return 584.0 - y;
    }

    private void createPath(WaypointPath p, Element root) {
        NodeList points = root.getChildNodes();
        for (int i = 0; i < points.getLength(); ++i) {
            Element e;
            if (!(points.item(i) instanceof Element) || !(e = (Element)points.item(i)).getTagName().equalsIgnoreCase("point")) continue;
            p.addPoint(this.transformX(Double.parseDouble(e.getAttribute("x"))), this.transformY(Double.parseDouble(e.getAttribute("y"))));
        }
    }

    private void addElements(Element node) {
        boolean addChildren = true;
        if (node.getTagName().equalsIgnoreCase("path")) {
            addChildren = false;
            WaypointPath p = new WaypointPath();
            this.paths.put(node.getAttribute("name"), p);
            this.createPath(p, node);
        }
        if (node.getTagName().equalsIgnoreCase("sprite")) {
            this.addSprite(node);
        }
        if (node.getTagName().equalsIgnoreCase("player")) {
            double x = 1.0;
            double y = 1.0;
            int life = 100;
            if (node.hasAttribute("x")) {
                x = Double.parseDouble(node.getAttribute("x"));
            }
            if (node.hasAttribute("y")) {
                y = Double.parseDouble(node.getAttribute("y"));
            }
            if (node.hasAttribute("life")) {
                life = Integer.parseInt(node.getAttribute("life"));
            }
            y = this.transformY(y) - (double)this.img.player[0].getHeight();
            x = this.transformX(x);
            this.player = new Player(this.img.player, x, y, 100L, this.parent, life);
        }
        if (addChildren) {
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                if (!(children.item(i) instanceof Element)) continue;
                this.addElements((Element)children.item(i));
            }
        }
    }

    private void addSprite(Element node) {
        boolean repeat;
        if (!node.hasAttribute("class")) {
            return;
        }
        String spriteClass = node.getAttribute("class");
        double x = 0.0;
        double y = 0.0;
        long delay = 10000L;
        String image = null;
        boolean tiles = true;
        int w = 1;
        int h = 1;
        if (!node.hasAttribute("w") || !node.hasAttribute("h")) {
            tiles = false;
        } else {
            w = Integer.parseInt(node.getAttribute("w"));
            h = Integer.parseInt(node.getAttribute("h"));
        }
        if (!node.hasAttribute("x")) {
            return;
        }
        x = Double.parseDouble(node.getAttribute("x"));
        if (!node.hasAttribute("y")) {
            return;
        }
        y = Double.parseDouble(node.getAttribute("y"));
        if (node.hasAttribute("delay")) {
            delay = Long.parseLong(node.getAttribute("delay"));
        }
        y = this.transformY(y);
        x = this.transformX(x);
        if (node.hasAttribute("image")) {
            image = node.getAttribute("image");
        }
        if (spriteClass.equalsIgnoreCase("wall")) {
            if (image == null) {
                image = "wall";
            }
            this.sprites.add(new Wall(this.getImg(image, tiles, w, h), x, y, delay, this.parent));
        }
        if (spriteClass.equalsIgnoreCase("sandstone")) {
            if (image == null) {
                image = "sandstone";
            }
            int time = 100;
            if (node.hasAttribute("time")) {
                time = Integer.parseInt(node.getAttribute("time"));
            }
            this.sprites.add(new Sandstone(this.getImg(image, tiles, w, h), x, y, delay, this.parent, time));
        }
        if (spriteClass.equalsIgnoreCase("hpball")) {
            if (image == null) {
                image = "hpball";
            }
            int life = 20;
            if (delay == 10000L) {
                delay = 50L;
            }
            if (node.hasAttribute("life")) {
                life = Integer.parseInt(node.getAttribute("life"));
            }
            this.sprites.add(new HPBall(this.getImg(image, tiles, w, h), x, y, delay, this.parent, life));
        }
        if (spriteClass.equalsIgnoreCase("hpgenerator")) {
            int direction = 0;
            if (node.getAttribute("direction").equalsIgnoreCase("left")) {
                direction = 1;
                image = "hpgenl";
            }
            if (node.getAttribute("direction").equalsIgnoreCase("up")) {
                direction = 2;
                image = "hpgenu";
            }
            if (node.getAttribute("direction").equalsIgnoreCase("right")) {
                direction = 3;
                image = "hpgenr";
            }
            if (node.getAttribute("direction").equalsIgnoreCase("down")) {
                direction = 4;
                image = "hpgend";
            }
            double speed = 50.0;
            if (node.hasAttribute("speed")) {
                speed = Double.parseDouble(node.getAttribute("speed"));
            }
            boolean repeat2 = true;
            if (node.hasAttribute("repeat")) {
                repeat2 = node.getAttribute("repeat").equalsIgnoreCase("true");
            }
            int life = 20;
            if (node.hasAttribute("life")) {
                life = Integer.parseInt(node.getAttribute("life"));
            }
            int frequency = 300;
            if (node.hasAttribute("frequency")) {
                frequency = Integer.parseInt(node.getAttribute("frequency"));
            }
            int ballSpeed = 60;
            if (node.hasAttribute("ballSpeed")) {
                ballSpeed = Integer.parseInt(node.getAttribute("ballSpeed"));
            }
            this.sprites.add(new HPGenerator(this.getImg(image, tiles, w, h), x, y, delay, this.parent, this.paths.get(node.getAttribute("follows")), speed, repeat2, direction, frequency, life, ballSpeed));
        }
        if (spriteClass.equalsIgnoreCase("mushroom")) {
            if (image == null) {
                image = "mushroom";
            }
            int poison = 50;
            if (node.hasAttribute("poison")) {
                poison = Integer.parseInt(node.getAttribute("poison"));
            }
            int speed = 30;
            if (node.hasAttribute("speed")) {
                speed = Integer.parseInt(node.getAttribute("speed"));
            }
            this.sprites.add(new Mushroom(this.getImg(image, tiles, w, h), x, y, delay, this.parent, poison, speed));
        }
        if (spriteClass.equalsIgnoreCase("spikes")) {
            if (image == null) {
                image = "spikes2";
            }
            int damage = 30;
            if (node.hasAttribute("damage")) {
                damage = Integer.parseInt(node.getAttribute("damage"));
            }
            this.sprites.add(new Spikes(this.getImg(image, tiles, w, h), x, y, delay, this.parent, damage));
        }
        if (spriteClass.equalsIgnoreCase("platform")) {
            if (image == null) {
                image = "wall";
            }
            double speed = 50.0;
            if (node.hasAttribute("speed")) {
                speed = Double.parseDouble(node.getAttribute("speed"));
            }
            repeat = true;
            if (node.hasAttribute("repeat")) {
                repeat = node.getAttribute("repeat").equalsIgnoreCase("true");
            }
            this.sprites.add(new Platform(this.getImg(image, tiles, w, h), x, y, delay, this.parent, this.paths.get(node.getAttribute("follows")), speed, repeat));
        }
        if (spriteClass.equalsIgnoreCase("shredder")) {
            if (image == null) {
                image = "shredder";
            }
            if (delay == 10000L) {
                delay = 10L;
            }
            this.sprites.add(new Shredder(this.getImg(image, tiles, w, h), x, y, delay, this.parent));
        }
        if (spriteClass.equalsIgnoreCase("key")) {
            if (image == null) {
                image = "key";
            }
            String target = null;
            if (node.hasAttribute("target")) {
                target = node.getAttribute("target");
            }
            this.sprites.add(new Key(this.getImg(image, tiles, w, h), x, y, delay, this.parent, target));
        }
        if (spriteClass.equalsIgnoreCase("Speedfield")) {
            int bx = 0;
            int by = 500;
            if (node.hasAttribute("bx")) {
                bx = Integer.parseInt(node.getAttribute("bx"));
            }
            if (node.hasAttribute("by")) {
                by = Integer.parseInt(node.getAttribute("by"));
            }
            if (image == null) {
                if (bx > 0) {
                    image = "arrowsr";
                }
                if (bx < 0) {
                    image = "arrowsl";
                }
                if (by < 0 && (image == null || Math.abs(by) > Math.abs(bx))) {
                    image = "arrowsu";
                }
            }
            this.sprites.add(new Speedfield(this.getImg(image, tiles, w, h), x, y, delay, this.parent, bx, by));
        }
        if (node.hasAttribute("name")) {
            this.actorIndex.put(node.getAttribute("name"), this.sprites.get(this.sprites.size() - 1));
        }
        if (node.hasAttribute("follows") && !spriteClass.equalsIgnoreCase("platform")) {
            double speed = 50.0;
            if (node.hasAttribute("speed")) {
                speed = Double.parseDouble(node.getAttribute("speed"));
            }
            repeat = true;
            if (node.hasAttribute("repeat")) {
                repeat = node.getAttribute("repeat").equalsIgnoreCase("true");
            }
            String pname = node.getAttribute("follows");
            Path p = null;
            if (pname.equalsIgnoreCase("sprite")) {
                String fsprite = node.getAttribute("sprite");
                if (!this.paths.containsKey("sprite_" + fsprite)) {
                    if (fsprite.equalsIgnoreCase("player")) {
                        this.paths.put("sprite_" + fsprite, new SpritePath(this.player));
                    } else {
                        this.paths.put("sprite_" + fsprite, new SpritePath(this.actorIndex.get(fsprite)));
                    }
                }
                p = this.paths.get("sprite_" + fsprite);
            } else {
                p = this.paths.get(pname);
            }
            this.sprites.get(this.sprites.size() - 1).setPath(p, speed, repeat);
        }
    }

    private BufferedImage[] getImg(String image, boolean tiles, int w, int h) {
        if (tiles) {
            return this.img.tileImages(this.img.getImagesByName(image), w, h);
        }
        return this.img.getImagesByName(image);
    }

    public ArrayList<Sprite> getActors() {
        return this.sprites;
    }

    public Hashtable<String, Sprite> getActorIndex() {
        return this.actorIndex;
    }

    public Player getPlayer() {
        return this.player;
    }
}

