/*
 * Decompiled with CFR 0.152.
 */
package engine;

import engine.MP3Player;
import engine.SoundEffect;
import engine.WavePlayer;
import java.io.File;
import java.util.Hashtable;

public class SoundLib {
    Hashtable<String, SoundEffect> sounds = new Hashtable();
    Hashtable<String, Integer> soundDelay = new Hashtable();
    Hashtable<String, Long> lastPlayed = new Hashtable();
    private MP3Player music;

    public SoundLib() {
        this.loadSound("beep", "life.wav", 50, 0, 0.0f);
        this.loadSound("boing", "boing.wav", 300, 5000, 6.0f);
        this.loadSound("key", "key.wav", 3000, 0, 20.0f);
        this.loadSound("stomp", "stomp.wav", 50, 0, 0.0f);
        this.loadSound("heart", "heart.wav", 3450, 0, 0.0f);
        this.loadSound("eating", "eating.wav", 200, 0, 0.0f);
        this.loadSound("splat", "splat.wav", 300, 2000, 0.0f);
    }

    public void loadSound(String name, String file, int delay, int offset, float boost) {
        if (this.sounds.containsKey(name)) {
            return;
        }
        try {
            SoundEffect s = new SoundEffect(new File("sound/" + file), offset, boost);
            this.sounds.put(name, s);
            this.soundDelay.put(name, delay);
        }
        catch (Exception e) {
            System.out.println(e.getLocalizedMessage());
        }
    }

    public void playSound(String name) {
        if (!this.sounds.containsKey(name)) {
            return;
        }
        if (this.lastPlayed.containsKey(name) && System.currentTimeMillis() - this.lastPlayed.get(name) < (long)this.soundDelay.get(name).intValue()) {
            return;
        }
        this.lastPlayed.put(name, System.currentTimeMillis());
        new WavePlayer(this.sounds.get(name)).start();
    }

    public void playMusic() {
        try {
            this.music = new MP3Player("sound/music.mp3");
            this.music.start();
        }
        catch (Exception e) {
            System.out.println(e.getLocalizedMessage());
        }
    }

    public void stopMusic() {
        if (this.music.isAlive()) {
            this.music.stopPlaying();
        }
    }
}

