/*
 * Decompiled with CFR 0.152.
 */
package gameobjects;

import engine.Path;
import engine.Vector2D;
import gameobjects.HPBall;
import gameobjects.Platform;
import java.awt.image.BufferedImage;
import view.GamePanel;

public class HPGenerator
extends Platform {
    private int direction;
    private int frequency;
    private int frequencyCounter;
    private int life;
    private int ballSpeed;

    public HPGenerator(BufferedImage[] i, double x, double y, long delay, GamePanel p, Path waypoints, double speed, boolean repeat, int direction, int frequency, int life, int ballSpeed) {
        super(i, x, y, delay, p, waypoints, speed, repeat);
        this.direction = direction;
        this.frequency = frequency;
        this.life = life;
        this.frequencyCounter = frequency - 1;
        this.ballSpeed = ballSpeed;
    }

    public void doLogic(long delta) {
        super.doLogic(delta);
        ++this.frequencyCounter;
        if (this.frequencyCounter > this.frequency) {
            this.frequencyCounter = 0;
            this.generateHPBall();
        }
    }

    private void generateHPBall() {
        int offX = 0;
        int offY = 0;
        Vector2D dir = new Vector2D(0.0, 0.0);
        switch (this.direction) {
            case 1: {
                offX = 1;
                offY = 5;
                dir.x = -1.0;
                break;
            }
            case 2: {
                offX = 5;
                offY = 1;
                dir.y = -1.0;
                break;
            }
            case 3: {
                offX = 29;
                offY = 5;
                dir.x = 1.0;
                break;
            }
            case 4: {
                offX = 5;
                offY = 29;
                dir.y = 1.0;
            }
        }
        HPBall b = new HPBall(this.parent.imgLib.getImagesByName("hpball"), this.x + (double)offX, this.y + (double)offY, 50L, this.parent, this.life);
        b.dv = dir;
        b.dv.scale(this.ballSpeed);
        this.parent.addActor(b);
    }
}

