/*
 * Decompiled with CFR 0.152.
 */
package gameobjects;

import engine.Vector2D;
import gameobjects.Player;
import gameobjects.Sprite;
import java.awt.image.BufferedImage;
import view.GamePanel;

public class Mushroom
extends Sprite {
    private int poison = 50;

    public Mushroom(BufferedImage[] i, double x, double y, long delay, GamePanel p, int poison, double speed) {
        super(i, x, y, delay, p);
        this.poison = poison;
        this.speed = Math.abs(speed);
        this.dv.x = speed;
        this.weight = 5;
    }

    public boolean collidedWith(Sprite s) {
        if (!this.remove && s instanceof Player && this.checkPixelPixelCollisions(s)) {
            this.remove = true;
            ((Player)s).setPoison(this.poison);
            this.parent.sound("eating");
        }
        return false;
    }

    public void forceMove(long delta, Vector2D v) {
        super.forceMove(delta, v);
        if (v.x < 0.0) {
            this.setHorizontalSpeed(-this.speed);
        }
        if (v.x > 0.0) {
            this.setHorizontalSpeed(this.speed);
        }
    }

    public void doAirDrag() {
    }
}

