/*
 * Decompiled with CFR 0.152.
 */
package gameobjects;

import engine.Drawable;
import engine.Vector2D;
import gameobjects.Movable;
import gameobjects.Particle;
import java.awt.Graphics;
import java.util.ArrayList;

public abstract class ParticleEffect
implements Drawable,
Movable {
    protected ArrayList<Particle> particles;
    protected int maxParticles;
    public boolean remove = false;
    protected Vector2D origin;

    public ParticleEffect(int maxParticles, Vector2D origin) {
        this.maxParticles = maxParticles;
        this.origin = origin;
        this.particles = new ArrayList();
    }

    public void doLogic(long delta) {
        for (int i = 0; i < this.particles.size(); ++i) {
            this.particles.get(i).doLogic(delta);
            if (!this.particles.get((int)i).remove) continue;
            this.particles.remove(i);
            --i;
        }
    }

    public void move(long delta) {
        for (int i = 0; i < this.particles.size(); ++i) {
            this.particles.get(i).move(delta);
        }
    }

    public void drawObjects(Graphics g) {
        if (this.particles == null) {
            return;
        }
        for (int i = 0; i < this.particles.size(); ++i) {
            if (this.particles.get(i) == null) continue;
            this.particles.get(i).drawObjects(g);
        }
    }
}

