/*
 * Decompiled with CFR 0.152.
 */
package gameobjects;

import engine.Path;
import engine.Vector2D;
import gameobjects.Player;
import gameobjects.Sprite;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import view.GamePanel;

public class Platform
extends Sprite {
    public Platform(BufferedImage[] i, double x, double y, long delay, GamePanel p, Path waypoints, double speed, boolean repeat) {
        super(i, x, y, delay, p);
        this.weight = 500;
        this.speed = speed;
        this.repeat = repeat;
        this.path = waypoints;
    }

    public boolean collidedWith(Sprite s) {
        if (s.weight == 0 || s.weight > this.weight) {
            return false;
        }
        boolean pushX = false;
        boolean pushY = false;
        boolean resetX = false;
        boolean resetY = false;
        Rectangle2D.Double xbox = new Rectangle2D.Double(this.oldX, this.y, this.width, this.height);
        Rectangle2D.Double ybox = new Rectangle2D.Double(this.x, this.oldY, this.width, this.height);
        pushX = !s.intersects(xbox);
        pushY = !s.intersects(ybox);
        double tmpX = s.x;
        s.x = s.oldX;
        boolean bl = resetX = !s.intersects(this);
        if (!(pushX || resetX || s.intersects(xbox))) {
            resetX = true;
            pushX = true;
        }
        s.x = tmpX;
        double tmpY = s.y;
        s.y = s.oldY;
        boolean bl2 = resetY = !s.intersects(this);
        if (!(pushY || resetY || s.intersects(ybox))) {
            resetY = true;
            pushY = true;
        }
        s.y = tmpY;
        if (!(resetX || resetY || pushX || pushY)) {
            resetY = true;
            resetX = true;
        }
        Vector2D force = new Vector2D(0.0, 0.0);
        if (resetY) {
            if (s.dv.y > 0.0) {
                if (s instanceof Player) {
                    ((Player)s).resetJump();
                    ((Player)s).cvo.x = 0.0;
                }
                s.dv.x = this.dv.x;
            }
            force.y = -s.dv.y;
            s.setVerticalSpeed(0.0);
        }
        if (resetX) {
            force.x = -s.dv.x;
            s.setHorizontalSpeed(0.0);
        }
        if (pushY) {
            force.y += this.dv.y;
        }
        if (pushX) {
            force.x += this.dv.x;
        }
        if (pushX || pushY || resetX || resetY) {
            s.forceMove(this.parent.delta, force);
        }
        return false;
    }

    public void doAirDrag() {
    }

    public void doGravity(Vector2D v) {
    }
}

