/*
 * Decompiled with CFR 0.152.
 */
package gameobjects;

import engine.Vector2D;
import gameobjects.Sprite;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import view.GamePanel;
import view.LifeBar;

public class Player
extends Sprite {
    int jumpStep = 0;
    int maxJumpStep = 5;
    private LifeBar life;
    int pain = 0;
    int picHeight = 1;
    int picHeightDir = 1;
    public Vector2D cv = new Vector2D(0.0, 0.0);
    public Vector2D cvo = new Vector2D(0.0, 0.0);
    boolean picStop = false;
    boolean dead = false;
    int poisoned = 0;

    public Player(BufferedImage[] i, double x, double y, long delay, GamePanel p, int life) {
        super(i, x, y, delay, p);
        this.weight = 10;
        this.life = new LifeBar(life, 2 * life);
    }

    public void resetJump() {
        if (this.jumpStep > 0) {
            this.jumpStep = -10;
        }
    }

    public void move(long delta) {
        if (this.jumpStep < 0) {
            ++this.jumpStep;
        }
        if (this.pain > 0) {
            --this.pain;
            delta /= 3L;
        }
        super.move(delta);
    }

    public void accelerate(Vector2D v) {
        if (v.y < 0.0 && this.jumpStep < this.maxJumpStep && this.jumpStep >= 0) {
            if (this.jumpStep == 0) {
                this.parent.sound("boing");
            }
            this.cv.y += (double)(this.maxJumpStep - this.jumpStep) * v.y;
            ++this.jumpStep;
        }
        this.cv.x += v.x;
        this.cv.capValues(250.0, 1000.0);
        if (Math.abs(this.cv.x) < 5.0) {
            this.cv.x = 0.0;
        }
        if (Math.abs(this.cv.y) < 5.0) {
            this.cv.y = 0.0;
        }
        Vector2D a = this.cv.vecSub(this.cvo);
        this.dv.add(a);
        this.cvo.x = this.cv.x;
        this.cvo.y = this.cv.y;
    }

    public void doLogic(long delta) {
        if (this.poisoned > 0) {
            --this.poisoned;
            this.life.changeLife(-1);
        }
        if (this.life.getLife() <= 0) {
            if (!this.dead) {
                this.dead = true;
                this.parent.setGameover();
                this.pics = this.parent.imgLib.getImagesByName("playerdead");
                this.currentpic = 0;
                this.picStop = true;
                this.setRect(this.x - 13.0, this.y + 15.0, this.getWidth(), this.pics[0].getHeight());
            }
        } else {
            super.doLogic(delta);
        }
    }

    protected void computeAnimation() {
        if (this.cv.x != 0.0) {
            this.picStop = false;
        }
        if (!this.picStop) {
            this.picHeight += this.picHeightDir;
            if (this.picHeight == 4 || this.picHeight == 1) {
                this.picHeightDir *= -1;
            }
            this.currentpic = 0;
            if (this.cv.x < 0.0) {
                this.currentpic = 4;
            }
            this.currentpic += this.picHeight;
        }
        if (this.picHeight == 1 && this.cv.x == 0.0) {
            this.currentpic = 0;
            this.picStop = true;
        }
        if (this.poisoned > 0) {
            this.currentpic += 9;
        }
    }

    public boolean collidedWith(Sprite s) {
        return false;
    }

    public void setPoison(int poison) {
        this.poisoned = poison;
    }

    public int getLife() {
        return this.life.getLife();
    }

    public void changeLife(int deltaL) {
        if (deltaL < 0) {
            this.pain = 30;
        }
        this.life.changeLife(deltaL);
    }

    public void setLife(int l) {
        this.life.setLife(l);
    }

    public boolean isDead() {
        return this.dead;
    }

    public void setVerticalSpeed(double d) {
        this.dv.y = d;
        this.cv.y = 0.0;
        this.cvo.y = 0.0;
    }

    public void setHorizontalSpeed(double d) {
        this.dv.x = d;
        this.cv.x = 0.0;
        this.cvo.x = 0.0;
    }

    public void doAirDrag() {
        super.doAirDrag();
        this.cvo.x *= 0.97;
        if (Math.abs(this.cvo.x) < 5.0) {
            this.cvo.x = 0.0;
        }
    }

    public void doGravity(Vector2D v) {
        this.dv.x += v.x;
        this.dv.y += v.y;
    }

    public void drawObjects(Graphics g) {
        super.drawObjects(g);
        this.life.drawObjects(g);
    }
}

