/*
 * Decompiled with CFR 0.152.
 */
package view;

import engine.Drawable;
import engine.ImageLib;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import view.Animation;
import view.GUIElement;
import view.GamePanel;

public class TitleScreen
implements Drawable {
    public ImageLib img;
    protected int selectedEntry = 0;
    protected int maxMenuEntry = 6;
    protected ArrayList<GUIElement> decoration;
    protected Animation cursor;
    protected String[] levels;
    protected int maxLevelNumber = 0;
    protected int selectedLevelIndex = 0;
    protected GamePanel parent;
    protected int activeBox = 0;
    protected int promoText;
    protected long promoTime;
    public int definingKey = -1;
    private int configEntry = 1;
    private static final int[] controlEntry = new int[]{0, 1, 2, 3, 6, 4, 5};
    private static final int[] cursorOffset = new int[]{0, 30, 90, 120, 150, 206, 236};

    public TitleScreen(ImageLib img, GamePanel p) {
        int i;
        this.img = img;
        this.parent = p;
        this.promoTime = 0L;
        this.decoration = new ArrayList();
        this.decoration.add(new Animation(img.tileImages(img.getImagesByName("wall"), 500, 304), 150, 200));
        this.decoration.add(new Animation(img.getImagesByName("wanna"), 40, 40));
        this.decoration.add(new Animation(img.getImagesByName("dead"), 420, 80));
        this.cursor = new Animation(img.getImagesByName("cursor"), 370, 230);
        File lvlDir = new File("level/");
        Object[] levelFiles = lvlDir.list();
        Arrays.sort(levelFiles);
        this.levels = new String[levelFiles.length];
        ArrayList<String> custom = new ArrayList<String>();
        for (i = 0; i < levelFiles.length; ++i) {
            if (this.setLevelString((String)levelFiles[i])) continue;
            custom.add(((String)levelFiles[i]).replace(".xml", ""));
        }
        for (i = 0; i < custom.size(); ++i) {
            this.levels[this.maxLevelNumber + i] = (String)custom.get(i);
        }
    }

    public String nextLevel(String currentlevel) {
        for (int i = 0; i < this.levels.length; ++i) {
            if (!this.levels[i].equals(currentlevel) || i + 1 >= this.levels.length) continue;
            return this.levels[i + 1];
        }
        return null;
    }

    public void setLevelIndexByName(String levelName) {
        for (int i = 0; i < this.levels.length; ++i) {
            if (!this.levels[i].equals(levelName)) continue;
            this.selectedLevelIndex = i;
            break;
        }
    }

    private boolean setLevelString(String levelFile) {
        if ((levelFile = levelFile.replace(".xml", "")).startsWith("level")) {
            int levelNumber = Integer.parseInt(levelFile.replace("level", ""));
            this.levels[levelNumber - 1] = levelFile;
            this.maxLevelNumber = Math.max(this.maxLevelNumber, levelNumber);
            return true;
        }
        return false;
    }

    public void defineNextKey() {
        ++this.definingKey;
        if (this.definingKey >= 4) {
            this.definingKey = -1;
        }
    }

    public void control(int key) {
        if (this.activeBox == 1) {
            if (key == 5) {
                this.activeBox = 0;
            }
            return;
        }
        if (this.activeBox == 2 && this.configEntry == 1 && key == 5) {
            this.activeBox = 0;
            return;
        }
        if (this.activeBox == 2) {
            switch (key) {
                case 1: 
                case 3: {
                    this.configEntry = 1 - this.configEntry;
                    break;
                }
                case 5: {
                    this.definingKey = 0;
                }
            }
            return;
        }
        block4 : switch (key) {
            case 1: {
                --this.selectedEntry;
                if (this.selectedEntry >= 0) break;
                this.selectedEntry = this.maxMenuEntry;
                break;
            }
            case 2: {
                switch (controlEntry[this.selectedEntry]) {
                    case 1: {
                        ++this.selectedLevelIndex;
                        if (this.selectedLevelIndex < this.levels.length) break;
                        this.selectedLevelIndex = 0;
                        break;
                    }
                    case 2: {
                        this.parent.setMusic(!this.parent.getMusic());
                        break;
                    }
                    case 3: {
                        this.parent.setSound(!this.parent.getSound());
                    }
                }
                break;
            }
            case 3: {
                ++this.selectedEntry;
                if (this.selectedEntry <= this.maxMenuEntry) break;
                this.selectedEntry = 0;
                break;
            }
            case 4: {
                switch (controlEntry[this.selectedEntry]) {
                    case 1: {
                        --this.selectedLevelIndex;
                        if (this.selectedLevelIndex >= 0) break;
                        this.selectedLevelIndex = this.levels.length - 1;
                        break;
                    }
                    case 2: {
                        this.parent.setMusic(!this.parent.getMusic());
                        break;
                    }
                    case 3: {
                        this.parent.setSound(!this.parent.getSound());
                    }
                }
                break;
            }
            case 5: {
                switch (controlEntry[this.selectedEntry]) {
                    case 0: 
                    case 1: {
                        this.parent.startLevel(this.levels[this.selectedLevelIndex]);
                        break block4;
                    }
                    case 2: {
                        this.parent.setMusic(!this.parent.getMusic());
                        break block4;
                    }
                    case 3: {
                        this.parent.setSound(!this.parent.getSound());
                        break block4;
                    }
                    case 4: {
                        this.activeBox = 1;
                        break block4;
                    }
                    case 5: {
                        this.parent.exitGame();
                        break block4;
                    }
                    case 6: {
                        this.activeBox = 2;
                    }
                }
            }
        }
    }

    public void drawObjects(Graphics g) {
        for (int i = 0; i < this.decoration.size(); ++i) {
            this.decoration.get(i).drawObjects(g);
        }
        g.setColor(Color.DARK_GRAY);
        g.fill3DRect(166, 216, 468, 273, false);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setColor(Color.white);
        switch (this.activeBox) {
            case 0: {
                this.cursor.setY(230 + cursorOffset[this.selectedEntry]);
                g.drawString("Start Game", 292, 242);
                g.drawString("Spiel starten", 440, 242);
                g.drawString("Level:", 327, 272);
                g.drawString(this.levels[this.selectedLevelIndex], 440, 272);
                g.drawString("Music", 323, 332);
                g.drawString("Musik", 440, 332);
                if (this.parent.getMusic()) {
                    g.drawImage(this.img.getImagesByName("on")[0], 550, 319, null);
                } else {
                    g.drawImage(this.img.getImagesByName("off")[0], 550, 319, null);
                }
                g.drawString("Sound Effects", 275, 362);
                g.drawString("Soundeffekte", 440, 362);
                if (this.parent.getSound()) {
                    g.drawImage(this.img.getImagesByName("on")[0], 550, 349, null);
                } else {
                    g.drawImage(this.img.getImagesByName("off")[0], 550, 349, null);
                }
                g.drawString("Controls", 309, 392);
                g.drawString("Steuerung", 440, 392);
                g.drawString("Credits", 317, 448);
                g.drawString("Danksagung", 440, 448);
                g.drawString("Exit Game", 300, 478);
                g.drawString("Spiel beenden", 439, 478);
                break;
            }
            case 1: {
                g.drawString("Programming / Programmierung:", 200, 250);
                g.drawString("Stefan \"Xeridar\" Hoffmann", 420, 250);
                g.drawString("Graphics / Grafiken:", 200, 280);
                g.drawString("Stefan \"Xeridar\" Hoffmann", 420, 280);
                g.drawString("Music & Sound / Musik & Sound:", 200, 310);
                g.drawString("freesound.org (sound/info.txt)", 420, 310);
                g.drawString("Beta Testing / Batetester:", 200, 340);
                g.drawString("\"Dimme\", \"Beavis2k\", \"Exxze\"", 420, 340);
                g.drawString("\"Tzuki\", \"Kamo\", \"klospulung0815\"", 420, 370);
                g.drawString("\"Voltan\", \"projectboylp\"", 420, 400);
                g.drawString("back", 330, 478);
                g.drawString("zur\u00fcck", 439, 478);
                this.cursor.setY(466);
                break;
            }
            case 2: {
                g.drawString("left / links:", 200, 250);
                if (this.definingKey == 0) {
                    g.drawString("???", 430, 250);
                } else if (this.parent.keyCodes[0] == GamePanel.keyCodesFixed[0]) {
                    g.drawString("arrow left / Pfeil nach links", 430, 250);
                } else {
                    g.drawString("(keycode #" + this.parent.keyCodes[0] + ")", 430, 250);
                }
                g.drawString("right / rechts:", 200, 280);
                if (this.definingKey == 1) {
                    g.drawString("???", 430, 280);
                } else if (this.parent.keyCodes[1] == GamePanel.keyCodesFixed[1]) {
                    g.drawString("arrow right / Pfeil nach rechts", 430, 280);
                } else {
                    g.drawString("(keycode #" + this.parent.keyCodes[1] + ")", 430, 280);
                }
                g.drawString("jump / springen:", 200, 310);
                if (this.definingKey == 2) {
                    g.drawString("???", 430, 310);
                } else if (this.parent.keyCodes[2] == GamePanel.keyCodesFixed[2]) {
                    g.drawString("arrow up / Pfeil nach oben", 430, 310);
                } else {
                    g.drawString("(keycode #" + this.parent.keyCodes[2] + ")", 430, 310);
                }
                g.drawString("reset level / Level neu starten:", 200, 340);
                if (this.definingKey == 3) {
                    g.drawString("???", 430, 340);
                } else if (this.parent.keyCodes[3] == GamePanel.keyCodesFixed[3]) {
                    g.drawString("space / Leertaste", 430, 340);
                } else {
                    g.drawString("(keycode #" + this.parent.keyCodes[3] + ")", 430, 340);
                }
                g.drawString("back / zur\u00fcck:", 200, 370);
                g.drawString("ESC", 430, 370);
                g.drawString("configure", 300, 448);
                g.drawString("konfigurieren", 439, 448);
                g.drawString("back", 330, 478);
                g.drawString("zur\u00fcck", 439, 478);
                this.cursor.setY(436 + 30 * this.configEntry);
            }
        }
        this.cursor.drawObjects(g);
        g.drawString("www.i-wanna-be-dead.de", 320, 520);
        g.drawString("v1.2", 770, 590);
        long ptime = new Date().getTime();
        if (ptime - this.promoTime > 20000L) {
            this.promoTime = ptime;
            this.promoText = (int)Math.floor(5.0 * Math.random());
        }
        switch (this.promoText) {
            default: {
                g.drawString("Im Fantasy Rollenspiel Browsergame unter www.arthoria.de sollten du und deine Mitspieler besser nicht sterben!", 45, 570);
                break;
            }
            case 1: {
                g.drawString("Dunkle Magier in www.arthoria.de versuchen gelegentlich den Tod zu \u00fcberlisten und als Liche zu existieren...", 60, 570);
                break;
            }
            case 2: 
            case 3: {
                g.drawString("Bist du tot? Eine Spruchrolle: Tote erwecken gibt es im Fantasy Rollenspiel www.arthoria.de !", 105, 570);
                break;
            }
            case 4: {
                g.drawString("Suchst du l\u00e4ngerfristigen Spielspa\u00df? Nebenbei im Browser? Versuche es bei www.arthoria.de !", 110, 570);
            }
        }
    }
}

